/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.montoyo.wd.client.gui.controls.Container;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.utilities.Bounds;
import org.lwjgl.opengl.GL11;

public class ControlGroup
extends Container {
    private int width;
    private int height;
    private String label;
    private int labelW;
    private int labelColor = -1;
    private boolean labelShadowed = true;

    public ControlGroup() {
        this.width = 100;
        this.height = 100;
        this.label = "";
        this.paddingX = 8;
        this.paddingY = 8;
    }

    public ControlGroup(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.paddingX = 8;
        this.paddingY = 8;
        this.label = "";
        this.labelW = 0;
    }

    public ControlGroup(int x, int y, int w, int h, String label) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.label = label;
        this.labelW = this.font.func_78256_a(label);
        this.paddingX = 8;
        this.paddingY = 8;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelW = this.font.func_78256_a(label);
    }

    public String getLabel() {
        return this.label;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    public boolean isLabelShadowed() {
        return this.labelShadowed;
    }

    public void setLabelShadowed(boolean labelShadowed) {
        this.labelShadowed = labelShadowed;
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        super.draw(mouseX, mouseY, ptt);
        if (this.visible) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            double x1 = this.x;
            double y1 = this.y;
            double x2 = this.x + this.width;
            double y2 = this.y + this.height;
            double bp = 4.0;
            double lw = this.labelW;
            x1 += bp;
            y1 += bp;
            x2 -= bp;
            y2 -= bp;
            lw += 12.0;
            this.vBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            if (this.labelW == 0) {
                this.vBuffer.func_181662_b(x1, y1 + 1.0, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x2, y1 + 1.0, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x2, y1, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x1, y1, 0.0).func_181675_d();
            } else {
                this.vBuffer.func_181662_b(x1, y1 + 1.0, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x1 + 8.0, y1 + 1.0, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x1 + 8.0, y1, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x1, y1, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x1 + lw, y1 + 1.0, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x2, y1 + 1.0, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x2, y1, 0.0).func_181675_d();
                this.vBuffer.func_181662_b(x1 + lw, y1, 0.0).func_181675_d();
            }
            this.vBuffer.func_181662_b(x1, y2, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x2, y2, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x2, y2 - 1.0, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x1, y2 - 1.0, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x1, y2, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x1 + 1.0, y2, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x1 + 1.0, y1, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x1, y1, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x2 - 1.0, y2, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x2, y2, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x2, y1, 0.0).func_181675_d();
            this.vBuffer.func_181662_b(x2 - 1.0, y1, 0.0).func_181675_d();
            this.tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            if (this.labelW != 0) {
                this.font.func_175065_a(this.label, (float)(this.x + 10 + (int)bp), (float)this.y, this.labelColor, this.labelShadowed);
            }
        }
    }

    public void pack() {
        Bounds bounds = ControlGroup.findBounds(this.childs);
        for (Control ctrl : this.childs) {
            ctrl.setPos(ctrl.getX() - bounds.minX, ctrl.getY() - bounds.minY);
        }
        this.width = bounds.getWidth() + this.paddingX * 2;
        this.height = bounds.getHeight() + this.paddingY * 2;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.width = json.getInt("width", 100);
        this.height = json.getInt("height", 100);
        this.label = ControlGroup.tr(json.getString("label", ""));
        this.labelW = this.font.func_78256_a(this.label);
        this.labelColor = json.getColor("labelColor", -1);
        this.labelShadowed = json.getBool("labelShadowed", true);
        if (json.getBool("pack", false)) {
            this.pack();
        }
    }
}

